<?php $__env->startSection('main_title', 'Home Page'); ?>
<?php $__env->startSection('header_title', 'Home'); ?>
<?php $__env->startSection('subheader_title', '#XV2'); ?>

<?php $__env->startSection('content'); ?>
    <div class="modal fade" tabindex="-1" id="kt_modal_1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('lang.title_modal')); ?></h5>

                    <!--begin::Close-->
                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal"
                         aria-label="Close">
                        <span class="svg-icon svg-icon-2x"></span>
                    </div>
                    <!--end::Close-->
                </div>

                <div class="modal-body">
                    <p><?php echo e(__('lang.body_modal')); ?></p>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('lang.but_cancel')); ?></button>
                    <button class="btn btn-danger" id="save-delete"><?php echo e(__('lang.but_save')); ?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" tabindex="-1" id="appear">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('lang.title_modal')); ?></h5>
                    <!--begin::Close-->
                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal"
                         aria-label="Close">
                        <span class="svg-icon svg-icon-2x"></span>
                    </div>
                    <!--end::Close-->
                </div>
                <div class="modal-body">
                    <form id="formappear">
                            <div class="form-group col-md-12">
                                <label class="form-label"> <?php echo e(__('lang.appear')); ?> :</label>
                                <select class="mb-10 form-select form-select-solid selDiv" aria-label="Select example" name="appear" id="appear_input">
                                    <option value="all"></option>
                                    <option value="best_seller"> <?php echo e(__('lang.best_seller')); ?></option>
                                    <option value="first_home_page"> <?php echo e(__('lang.first_home_page')); ?></option>
                                    <option value="most_recent"> <?php echo e(__('lang.most_recent')); ?></option>
                                    <option value="only_product"> <?php echo e(__('lang.only_product')); ?></option>
                                </select>
                            </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('lang.but_cancel')); ?></button>
                    <button class="btn btn-success" id="save-appear"><?php echo e(__('lang.but_save')); ?></button>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-5 mb-xl-8">
        <!--begin::Header-->
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1"><?php echo e(__('lang.titleproducts')); ?></span>
            </h3>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Product-Create')): ?>
            <div class="card-toolbar" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-trigger="hover"
                 title="Click to add a productsegory">

                    <a href="<?php echo e(route('products.create', ['category' => $id ?? ""])); ?>" class="btn btn-sm btn-light-primary">

                    <span class="svg-icon svg-icon-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px"
                             viewBox="0 0 24 24" version="1.1">
													<path
                                                        d="M18,8 L16,8 C15.4477153,8 15,7.55228475 15,7 C15,6.44771525 15.4477153,6 16,6 L18,6 L18,4 C18,3.44771525 18.4477153,3 19,3 C19.5522847,3 20,3.44771525 20,4 L20,6 L22,6 C22.5522847,6 23,6.44771525 23,7 C23,7.55228475 22.5522847,8 22,8 L20,8 L20,10 C20,10.5522847 19.5522847,11 19,11 C18.4477153,11 18,10.5522847 18,10 L18,8 Z M9,11 C6.790861,11 5,9.209139 5,7 C5,4.790861 6.790861,3 9,3 C11.209139,3 13,4.790861 13,7 C13,9.209139 11.209139,11 9,11 Z"
                                                        fill="#000000" fill-rule="nonzero" opacity="0.3"/>
													<path
                                                        d="M0.00065168429,20.1992055 C0.388258525,15.4265159 4.26191235,13 8.98334134,13 C13.7712164,13 17.7048837,15.2931929 17.9979143,20.2 C18.0095879,20.3954741 17.9979143,21 17.2466999,21 C13.541124,21 8.03472472,21 0.727502227,21 C0.476712155,21 -0.0204617505,20.45918 0.00065168429,20.1992055 Z"
                                                        fill="#000000" fill-rule="nonzero"/>
												</svg>
                    </span><?php echo e(__('lang.New_product')); ?></a>
            </div>
            <?php endif; ?>
        </div>
        <?php if(Session::has('success')): ?>
            <div class="alert alert-success" style="margin: 15px">
                <?php echo e(Session::get('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(Session::has('delete')): ?>
            <div class="alert alert-danger" style="margin: 15px">
                <?php echo e(Session::get('delete')); ?>

            </div>
        <?php endif; ?>
        <?php if(Session::has('warning')): ?>
            <div class="alert alert-warning" style="margin: 15px">
                <?php echo e(Session::get('warning')); ?>

            </div>
        <?php endif; ?>
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body py-3">
            <!--begin::Table container-->
            <div class="table-responsive" id="table-data">
                <!--begin::Table-->
                <?php echo $__env->make('dashboard.Products.table-data', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
       <script>
        $(document).ready(function() {
            // تفعيل Select2
            // $('#tag-select').select2({
            //     placeholder: 'اختر وسمًا',
            //     allowClear: true
            // });

            // عند تغيير الاختيار
            $('#tag-select').on('change', function() {
                var selected = $(this).val(); // مصفوفة من القيم
                var selectedOptions = $(this).find('option:selected');
                selectedOptions.each(function() {
                    var tagText = $(this).text(); // الاسم (الظاهر)
                    var tagValue = $(this).val(); // الرقم (value)


                    $('#tag-textarea').val($('#tag-textarea').val() +
                        ',' + tagText); // دمجهم بفاصلة ومسافة
                    $('#tag-value').val($('#tag-value').val() + ',' + tagValue)
                });
            });


        });
    </script>
    <script>
         $("#products").DataTable({
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'تصدير إلى Excel',
                    className: 'btn btn-success'
                }
            ],
            language: {
                url: "<?php echo e(asset('dashboard/assets/plugins/custom/datatables/lang/ar.json')); ?>" // إذا كنت تستخدم لغة عربية
            }
        });
        $(document).on('click', '#status' ,function (e){
            e.preventDefault();
            var id = $(this).data('id');
            var type = "<?php echo e(request()->get('type')); ?>";
            if (type){

            }else{
                type = "";
            }
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: '<?php echo e(url('admin/products/Stauts')); ?>/'+id,
                data: '',
                success: function (response) {
                    $.ajax({
                        url: "<?php echo e(route('products.index')); ?>?type="+type
                    }).done(function(data) {
                        $("#table-data").html(data);
                        $("#products").DataTable();
                    });
                }
            });
        });

        $(document).on('click', '#delete' ,function (e){
            e.preventDefault();
            var id = $(this).data('id');
            delete_f(id);
        });
        function delete_f(id) {
            $(document).off("click", "#save-delete").on("click", "#save-delete", function (e) {
                e.preventDefault();
                var type = "<?php echo e(request()->get('type')); ?>";
                if (type){

                }else{
                    type = "";
                }
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'post',
                    url: '<?php echo e(url('admin/products/destroy')); ?>/' + id,
                    data: '',
                    success: function (response) {
                        Swal.fire({
                            title: '<?php echo e(__('lang.Good_job')); ?>',
                            text: '<?php echo e(__('lang.You_clicked_button')); ?>',
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: '<?php echo e(__('lang.Confirm_me')); ?>',
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                        $('#kt_modal_1').modal('hide');
                        $.ajax({
                            url: "<?php echo e(route('products.index')); ?>?type="+type
                        }).done(function (data) {
                            $("#table-data").html(data);
                            $("#products").DataTable();
                        });
                    }
                });
            });
        }

        $(document).on('click', '#appear_but' ,function (e){
            e.preventDefault();
            $('#appear').modal('show');
            var id = $(this).data('id');
            var appear = $(this).data('appear');
            $('.selDiv option[value="'+appear+'"]').prop('selected', true)
            appear_update(id);
        });
        function appear_update(id) {
            $(document).off("click", "#save-appear").on("click", "#save-appear", function (e) {
                e.preventDefault();
                let formdata = new FormData($('#formappear')[0]);
                var type = "<?php echo e(request()->get('type')); ?>";
                if (type){

                }else{
                    type = "";
                }
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'post',
                    url: '<?php echo e(url('admin/products/appearUpdate')); ?>/' + id,
                    data: formdata,
                    contentType: false,
                    processData: false,
                    success: function (response) {
                        Swal.fire({
                            title: '<?php echo e(__('lang.Good_job')); ?>',
                            text: '<?php echo e(__('lang.You_clicked_button')); ?>',
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: '<?php echo e(__('lang.Confirm_me')); ?>',
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                        $('#appear').modal('hide');
                        $.ajax({
                            url: "<?php echo e(route('products.index')); ?>?type="+type
                        }).done(function (data) {
                            $("#table-data").html(data);
                            $("#products").DataTable();
                        });
                    }
                });
            });
        }

    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/dashboard/Products/index.blade.php ENDPATH**/ ?>