<table class="table axil-product-table axil-wishlist-table">
    <thead>
    <tr>
        <th scope="col" class="product-remove"></th>
        <th scope="col" class="product-thumbnail"><?php echo e(__('lang.Product')); ?></th>
        <th scope="col" class="product-title"></th>
        <th scope="col" class="product-price"><?php echo e(__('lang.price')); ?></th>
        <th scope="col" class="product-add-cart"><?php echo e(__('lang.Colors')); ?></th>
        <th scope="col" class="product-title"></th>

    </tr>
    </thead>

    <tbody>
    <?php $__currentLoopData = $favorites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td class="product-remove">

                <button type="submit" class="remove-wishlist" data-id="<?php echo e($favorite->id); ?>">
                    <i class="fal fa-times"></i>
                </button>

            </td>
            <td class="product-thumbnail">
                <a href="<?php echo e(route('product.show', $favorite->product->id)); ?>">
                    <img src="<?php echo e(Request::root() . '/dashboard/images/' . $favorite->product->image); ?>" alt="Digital Product">
                </a>
            </td>
            <td class="product-title">
                <a href="<?php echo e(route('product.show', $favorite->product->id)); ?>">
                    <?php if(  app()->getLocale() == 'en'): ?>
                        <?php echo e($favorite->product->name_en); ?>

                    <?php else: ?>
                        <?php echo e($favorite->product->name_ar); ?>

                    <?php endif; ?>
                </a>
            </td>
            <td class="product-price" data-title="Price">
                <span class="currency-symbol"><?php echo e(__('lang.sar')); ?></span>


                <?php echo e(number_format(($favorite->product->price - ($favorite->product->price * $favorite->product->discount/100))  + (($tax_tax/100) * $favorite->product->price) , 2)); ?>

                <br>
                <span class="text-tax"><?php echo e(__('lang.tax_pro')); ?></span>
            </td>
            <td class="product-add-cart">
                <div class="color-variant-wrapper">
                    <ul class="color-variant">
                        <?php $__currentLoopData = $favorite->product->colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="mx-2 color-extra-01">
                            <div class="box-color d-flex">
                                <div class="container-color-box d-flex mb-4">
                                    <input name="color" class="color" type="radio" data-id="<?php echo e($favorite->product->id); ?>" id="color-<?php echo e($colors->id); ?>"
                                           value="<?php echo e($colors->color); ?>" data-color="<?php echo e($colors->color); ?>"/>
                                    <label for="color-<?php echo e($colors->id); ?>" style="--myVar:<?php echo e($colors->color); ?>;"></label>
                                </div>
                            </div>


                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </td>
            <td>
                <form action="<?php echo e(route('cart.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="color" id="colorForm<?php echo e($favorite->product->id); ?>">

                    <input type="hidden" name="quantity" id="in_quantity_<?php echo e($favorite->product->id); ?>">

                    <input type="hidden" name="product_id" value="<?php echo e($favorite->product->id); ?>">

                    <button type="submit" id="cart-btn" class="add-product" data-id="<?php echo e($favorite->product->id); ?>">
                        <?php echo e(__('lang.add-cart')); ?>

                    </button>
                </form>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
<?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/favorite/table-data.blade.php ENDPATH**/ ?>