

<?php $__env->startSection('css'); ?>
    <style>
        body {
            background: #fafafa
        }

        .compare-scroller {
            gap: 1rem;
            padding-bottom: .75rem
        }

        .compare-col {
            width: 320px
        }

        .product-card {
            border: 1px solid #eee;
            border-radius: 1rem;
            overflow: hidden;
            background: #fff;
            margin-bottom: 1rem;
            padding: 1rem;
            text-align: center
        }

        .product-card img {
            max-height: 120px;
            object-fit: contain;
            margin-bottom: .5rem
        }

        .price {
            font-weight: 700;
            font-size: 18px
        }

        .old-price {
            text-decoration: line-through;
            color: #999;
            margin-inline-start: .5rem
        }

        .btn-cart {
            background: #782569;
            border: none;
            color: #fff;
            width: 100%;
            margin-top: .5rem
        }

        .btn-cart:hover {
            background: #5f1c4c
        }

        .feature-cell {
            border-top: 1px solid #eee;
            padding: .75rem;
            text-align: center;
            background: #fff
        }

        .feature-label {
            font-size: 12px;
            color: #666;
            margin-bottom: .25rem;
            font-weight: 700;
        }

        .feature-value {
            font-weight: 700;
            font-size: 14px;
        }

        .yes {
            color: #137333
        }

        .no {
            color: #a12c2c
        }

        /* على الديسكتوب: نحولها Grid بعدد الأعمدة = عدد المنتجات */
        @media (min-width: 992px) {
            .compare-scroller {
                display: grid !important;
                grid-template-columns: repeat(var(--cols), 1fr);
                overflow: visible !important;
            }

            .compare-col {
                width: auto
            }

        }

        span.price.old-price {
            color: red !important;
            font-size: 18px;
        }
        .btn-cart{
                width: fit-content !important;
    padding: 5px 20px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // تأكيد عدم التكرار داخل الـBlade (حماية إضافية)
        $products = $compare_product->unique('id')->values();
        $colsCount = $compare_product->count();
    ?>

    <div class="container py-4">
        <h5 class="mb-4">مقارنة المنتجات</h5>

        <!-- على الجوال: أفقي بسكرول | على الديسكتوب: Grid -->
        <div class="compare-scroller d-flex flex-nowrap overflow-auto" style="--cols: <?php echo e($colsCount); ?>;">

            <?php $__currentLoopData = $compare_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="compare-col flex-shrink-0">
                    <!-- بطاقة المنتج -->
                    <div class="product-card">


                        
                        <img src="<?php echo e(Request::root() . '/dashboard/images/' . $p->image); ?>"
                            alt="<?php echo e($p->name_ar ?? 'product'); ?>" loading="lazy">
                        <p class="mb-2 h6">
                            <?php echo e($p->name_ar); ?>

                        </p>

                        <div class="d-flex justify-content-center align-items-center">
                           
                            <?php
                                $price = (float) $p->price;
                                $discountPct = (float) ($p->discount ?? 0); // نسبة الخصم %
                                $taxPct = (float) ($tax_tax ?? 0); // نسبة الضريبة %
                                $decimals = 0; // غيّرها لـ 2 لو تبغى كسور

                                // السعر مع الضريبة (قبل الخصم)
                                $oldTotal = $price * (1 + $taxPct / 100);

                                // السعر بعد الخصم + الضريبة
                                $discountedPrice = $price * (1 - $discountPct / 100);
                                $newTotal = $discountedPrice * (1 + $taxPct / 100);
                            ?>

                            <?php if($discountPct > 0): ?>
                                <span class="price old-price">
                                    <?php echo e(number_format($oldTotal, $decimals)); ?>

                                    <i class="sicon-sar"></i>
                                </span>
                                <span class="price current-price">
                                    <?php echo e(number_format($newTotal, $decimals)); ?>

                                    <i class="sicon-sar"></i>
                                </span>
                            <?php else: ?>
                                <span class="price current-price">
                                    <?php echo e(number_format($oldTotal, $decimals)); ?>

                                    <i class="sicon-sar"></i>
                                </span>
                            <?php endif; ?>

                        </div>
                         <form action="<?php echo e(route('cart.store')); ?>" method="POST" class="addToCartForm">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="color" value="<?php echo e($p->colors[0]->color); ?>">
                            <input type="hidden" name="product_id" value="<?php echo e($p->id); ?>">
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="flag" value="1">
                            <button class="btn-cart ">
                                <?php echo e(__('lang.add-cart')); ?>

                            </button>

                        </form>
                    </div>

                    

                    <?php $__currentLoopData = ($p->specifications ?? collect())->unique(function ($row) {
            // تخلّص من التكرارات حسب العنوان (AR/EN)
            return app()->getLocale() === 'ar' ? $row->title_ar ?? ($row->title_en ?? ($row->title ?? '')) : $row->title_en ?? ($row->title_ar ?? ($row->title ?? ''));
        }); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // العنوان حسب اللغة
                            $title =
                                app()->getLocale() === 'ar'
                                    ? $s->title_ar ?? ($s->title_en ?? ($s->title ?? ''))
                                    : $s->title_en ?? ($s->title_ar ?? ($s->title ?? ''));

                            // القيمة حسب اللغة
                            $value =
                                app()->getLocale() === 'ar'
                                    ? $s->option_ar ??
                                        ($s->value_ar ?? ($s->option_en ?? ($s->value_en ?? ($s->value ?? ''))))
                                    : $s->option_en ??
                                        ($s->value_en ?? ($s->option_ar ?? ($s->value_ar ?? ($s->value ?? ''))));

                            $raw = trim((string) $value);
                            $low = mb_strtolower($raw, 'UTF-8');

                            // كشف نعم/لا (عربي/إنجليزي/قيم منطقية/رقمية صريحة)
                            $isBool = in_array($low, ['1', '0', 'true', 'false', 'yes', 'no', 'نعم', 'لا'], true);

                            $class = '';
                            if ($isBool) {
                                $isYes = in_array($low, ['1', 'true', 'yes', 'نعم'], true);
                                if (app()->getLocale() === 'ar') {
                                    $valueOut = $isYes ? 'نعم' : 'لا';
                                } else {
                                    $valueOut = $isYes ? 'Yes' : 'No';
                                }
                                $class = $isYes ? 'yes' : 'no';
                            } else {
                                $valueOut = $raw !== '' ? $raw : '-';
                            }
                        ?>

                        <div class="feature-cell">
                            <div class="feature-label"><?php echo e($title); ?></div>
                            <div class="feature-value <?php echo e($class); ?>"><?php echo e($valueOut); ?></div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    
                    

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>

        <div class="text-muted small mt-2">اسحب لليمين/اليسار على الجوال لعرض كل الأعمدة.</div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function() {
            // $(".addToCartFormbtn").prop("disabled", false);
            $('.addToCartForm').on('submit', function(e) {

               
                e.preventDefault(); // Prevent normal form submission
                e.stopPropagation();



                let formData = $(this).serialize(); // Serialize form data
               

                $.ajax({
                    url: "<?php echo e(route('cart.store')); ?>",
                    type: "POST",
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // CSRF token
                    },
                    success: function(response) {
                        console.log(response);
                        console.log(response['quantity_false']);
                        if (response['quantity_false'] == '1') {
                            Swal.fire({
                                position: 'top-end',
                                title: 'الكمية نفذت',
                                showConfirmButton: false,
                                icon: 'error',
                                timer: 3000
                            });
                        } else {
                            $('.cart-count').text(response['data']);
                            Swal.fire({
                                position: 'top-end',
                                title: '<?php echo e(__('lang.add_salla')); ?>',
                                showConfirmButton: false,
                                icon: 'success',
                                timer: 3000
                            });
                        }

                    },
                    error: function(xhr) {
                        console.log(xhr.responseText); // Log error to console
                        alert("Something went wrong. Please try again.");
                    }
                });
                return false;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/product/compare_product.blade.php ENDPATH**/ ?>