<?php

use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\ConfirmablePasswordController;
use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\VerifyEmailController;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App\Http\Controllers\Auth\ActivationController;
use App\Http\Controllers\Auth\GoogleController;



Route::middleware('guest')
    ->prefix(LaravelLocalization::setLocale())
    ->group(function () {
    Route::get('register', [RegisteredUserController::class, 'create'])
                ->name('register');

    Route::post('register', [RegisteredUserController::class, 'store']);
        Route::get('/verify-otp', [RegisteredUserController::class, 'showVerifyOtp'])->name('verify.otp');
Route::post('/verify-otp', [RegisteredUserController::class, 'verifyOtp'])->name('verify.otp.post');
Route::get('/resend-otp', [RegisteredUserController::class, 'resend_otp'])->name('verify.otp.resend');

Route::get('activation/{email}', [ActivationController::class, 'showActivationPage'])->name('activation.page');
Route::post('activate-account', [ActivationController::class, 'activateAccount'])->name('activate.account');
 Route::get('callback/acccount', [ActivationController::class, 'callback_acccount'])->name('callback_acccount.page');

  Route::get('registerGoogle', [GoogleController::class, 'registerGoogl'])->name('registerGoogl');
 Route::get('callbackGoogle', [GoogleController::class, 'callbackGoogle'])->name('callbackGoogle');


    Route::get('login', [AuthenticatedSessionController::class, 'create'])
                ->name('login');

    Route::post('login', [AuthenticatedSessionController::class, 'store']);

    Route::get('admin/login', [AuthenticatedSessionController::class, 'createAdmin'])
        ->name('login.admin');

    Route::post('admin/login', [AuthenticatedSessionController::class, 'storeAdmin'])->name('login.admin.store');

    Route::get('forgot-password', [PasswordResetLinkController::class, 'create'])
                ->name('password.request');

    Route::post('forgot-password', [PasswordResetLinkController::class, 'store'])
                ->name('password.email');

    Route::get('reset-password/{token}', [NewPasswordController::class, 'create'])
                ->name('password.reset');

    Route::post('reset-password', [NewPasswordController::class, 'store'])
                ->name('password.update');
});

Route::middleware('auth:web,admin')->prefix(LaravelLocalization::setLocale())->group(function () {
    Route::get('verify-email', [EmailVerificationPromptController::class, '__invoke'])
                ->name('verification.notice');

    Route::get('verify-email/{id}/{hash}', [VerifyEmailController::class, '__invoke'])
                ->middleware(['signed', 'throttle:6,1'])
                ->name('verification.verify');

    Route::post('email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
                ->middleware('throttle:6,1')
                ->name('verification.send');

    Route::get('confirm-password', [ConfirmablePasswordController::class, 'show'])
                ->name('password.confirm');

    Route::post('confirm-password', [ConfirmablePasswordController::class, 'store']);

    Route::get('logout', [AuthenticatedSessionController::class, 'destroy'])
                ->name('logout');

});
    Route::get('admin/logout', [AuthenticatedSessionController::class, 'destroyAdmin'])
        ->middleware(['auth:admin'])->name('admin.logout');
