<?php

use App\Http\Controllers\API\EmcanPaymentController;
use App\Http\Controllers\API\OrderController;
use App\Http\Controllers\API\ProductController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\API\V1\AddressesController;
use App\Http\Controllers\API\V1\Auth\AuthBaseController;
use App\Http\Controllers\API\V1\Auth\AuthController;
use App\Http\Controllers\Api\V1\BranchController;
use App\Http\Controllers\API\V1\CategoriesController;
use App\Http\Controllers\API\V1\CartsController;
use App\Http\Controllers\API\V1\ContactController;
use App\Http\Controllers\API\V1\FavoritesController;
use App\Http\Controllers\API\V1\HomeController;
use App\Http\Controllers\API\V1\LocationsController;
use App\Http\Controllers\API\V1\NotificationsController;
use App\Http\Controllers\API\V1\OrderControllerApp;
use App\Http\Controllers\API\V1\ProductsController;
use App\Http\Controllers\API\V1\SettingController;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('getVoucherDetails' , [EmcanPaymentController::class , 'getVoucherDetails']);
Route::post('preRedeem' , [EmcanPaymentController::class , 'preRedeem']);
Route::post('redeem' , [EmcanPaymentController::class , 'redeem']);
Route::post('preRefund' , [EmcanPaymentController::class , 'preRefund']);
Route::post('refund' , [EmcanPaymentController::class , 'refund']);

Route::post('order/index' , [OrderController::class , 'index']);
Route::post('order/show' , [OrderController::class , 'show']);


Route::post('product/show' , ProductController::class);


Route::middleware('auth:sanctum')->group(function () {
    Route::get("card/index", [CartsController::class, 'index']);
    Route::post("card/updateQuantity", [CartsController::class, 'updateCartQuantity']); 
    Route::post('cart/add', [CartsController::class, 'store']);
    Route::apiResource('favorite', FavoritesController::class);
    
});



Route::get('product/{id}', [ProductsController::class, 'show']);
Route::get('categories', [CategoriesController::class, 'index']);
Route::get('product_category/{id}', [CategoriesController::class, 'product_category']);

Route::get('products', [ProductsController::class, 'index']);
Route::get('products/search', [ProductsController::class, 'search_product']);
Route::get('product/{id}/similar', [ProductsController::class, 'similarProduct']);
Route::get('home', [HomeController::class, 'index']);

// Route::post('cart/add', [CartsController::class, 'store']);
Route::post('cart/delete', [CartsController::class, 'delete']);

Route::post("card/clearCart", [CartsController::class, "clearCart"]);
Route::get("branch", [BranchController::class, "index"]);
Route::apiResource('favorite', FavoritesController::class);


// app route

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Route::middleware('setLocale')->prefix('V1')->group(function () {
Route::prefix('V1')->group(function () {
    Route::get('send/notifications', function () {
        Artisan::call('db:seed --class=SendNotifications');
        return 'successfully';
    });

    Route::post('login', [AuthController::class, 'login']);
    Route::post('register', [AuthController::class, 'register']);
     Route::post('verifyCode', [AuthController::class, 'verifyCode']);
    Route::post('submitcode', [AuthController::class, 'submitCode']);
    // Route::get('setting', SettingController::class);
    // Route::get('category', CategoriesController::class);
    Route::post('variant/get', [ProductsController::class, 'getVariant']);


    // Route::middleware(['auth:sanctum', 'activeUser'])->group(function () {
    Route::get('user', [AuthController::class, 'show']);
    Route::put('user/update', [AuthController::class, 'update']);

    // Route::get('products', [ProductsController::class, 'index']);
    // Route::get('location', LocationsController::class);
    // Route::post('contact', ContactController::class);
    // Route::apiResource('favorite', FavoritesController::class);
    Route::get('user/{id}/clear/favorites', [FavoritesController::class, 'clearUserFavorites']);
    Route::get('favorites/get', [FavoritesController::class, 'getFavorites']);
    Route::get('cities/get', [AddressesController::class, 'getCities']);
    Route::apiResource('address', AddressesController::class);
    Route::get('set/{id}/default/address', [AddressesController::class, 'setDefaultAddress']);
    Route::apiResource('notification', NotificationsController::class);
    Route::delete('destory', [AuthController::class, 'destory']);
    Route::get('logout', [AuthBaseController::class, 'logout']);


    Route::post('product/review', [ProductsController::class, 'reviewProduct']);
    Route::get('product/{id}/view', [ProductsController::class, 'viewProduct']);

    Route::apiResource('cart', CartsController::class);
    Route::apiResource('order', OrderController::class);
});
// });


// end app route


