@extends('layouts.front_layout')

@if (app()->getLocale() == 'en')
    @section('title', $seo?->meta_title_en)
    @section('description', $seo?->meta_description_en)
    @section('canonical', $seo?->canonical_en)
@else
    @section('title', $seo?->meta_title_ar)
    @section('description', $seo?->meta_description_ar)
    @section('canonical', $seo?->canonical_ar)
@endif

@section('css')
    <style>
        :root {
            --main-color: #782569;
            /* اللون الأساسي */
            --secondary-color: #fff;
            /* اللون الثانوي (أبيض) */
        }

        .axil-section-gap {
            padding: 10px
        }

        h1,
        h2,
        h5 {
            color: var(--main-color);
        }

        /* الأقسام */
        .header-about {
            /*background-color: var(--main-color);*/
            /*color: var(--secondary-color);*/
        }

        .header-about h1 {
            font-size: 2.5rem;
            font-weight: bold;
        }

        .header-about p {
            font-size: 1.2rem;
        }

        /* النصوص الأساسية */
        .text-primary {
            color: var(--main-color) !important;
        }

        .text-white {
            color: var(--secondary-color) !important;
        }

        /* البطاقات */
        .card {
            border: 1px solid var(--main-color);
        }

        .card-title {
            color: var(--main-color);
            font-weight: bold;
        }

        .card-body p {
            color: #333;
            /* لون النصوص الداخلية */
        }

        /* أزرار وعناصر إضافية */
        .list-group-item {
            border: 1px solid var(--main-color);
            background-color: #f9f9f9;
            padding: 20px
        }

        .list-group-item strong {
            color: var(--main-color);
        }

        .list-group-item::before {
            content: "•";
            color: var(--main-color);
            margin-right: 8px;
        }

        /* تباعد */
        .my-5 {
            margin-top: 3rem !important;
            margin-bottom: 3rem !important;
        }

        @media (max-width: 768px) {
            .header-about {


                background-color: var(--main-color);
                color: var(--secondary-color);
            }

            .header-about h1,
            .header-about h2 {
                color: var(--secondary-color);

            }

        }
        .img-hero{
            background-image:url("https://newnetwork.sa/dashboard/sliderimage/41WQgReEmU8d1732356535.jpeg");
                height: 342px;

        }
    </style>

@endsection

@section('content')
    @php
        $breadcrumb_schema = [
            ['name' => __('lang.Home'), 'url' => url('/')],
            ['name' => __('lang.about'), 'url' => request()->fullUrl()],
        ];
    @endphp
    @include('components.breadcrumb')

@if (app()->getLocale() == 'en')

  @include('components.about_en')
@else
  @include('components.about_ar')
@endif
    <!-- Start Why Choose Area  -->

    <!-- End Why Choose Area  -->
@endsection

@section('js')

    <script type="application/ld+json">
    {
      "@context": "https://schema.org/",
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "{{ __('lang.Home') }}",
          "item": "{{ route('home') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "{{ __('lang.about') }}",
          "item": "{{ request()->fullUrl() }}"
        }
      ]
    }
</script>

@endsection
