@extends('layouts.front_layout')

@section('title', 'gift')

@section('css')
<style>
    @import url("https://fonts.googleapis.com/css2?family=Fira+Sans+Extra+Condensed:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap");
    @import url("https://fonts.googleapis.com/css2?family=Heebo:wght@100;200;300;400;500;600;700;800;900&display=swap");
    @import url("https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap");
    :root {
      --font1: "Heebo", sans-serif;
      --font2: "Fira Sans Extra Condensed", sans-serif;
      --font3: "Roboto", sans-serif;
    }
    body {
      font-family: var(--font3);
      background-image: linear-gradient(120deg, #fdfbfb 0%, #ebedee 100%);
      overflow: hidden;
    }
    .hero-section {
    height: 50vh; /* 100% من ارتفاع الشاشة */
}

@media (max-width: 768px) {
    .hero-section {
        height: auto; /* السماح للارتفاع بالتكيف تلقائيًا */
        padding: 50px 0; /* إضافة مسافات عمودية */
    }
}
.btn-select{
 
    background-color: #782569;
    color: white;
    font-size: 16px;
    padding: 5px 11px;
    border-radius: 7px;
}
.container-btn-select{
    position: absolute;
    bottom: 5px;
    right: 21%;
}
.card-body{
    height: 15rem;
}

  </style>
@endsection

@section('content')
    <!-- Hero Section -->
    <section class="hero-section d-flex align-items-center" style="height: 50vh; background: url('https://thumbs.dreamstime.com/b/gift-packaging-vibrant-green-leaf-motifs-ribbon-fluttering-isolated-transparent-background-captivating-hero-shot-gift-350701474.jpg') no-repeat center center / cover;">
        <div class="container text-center text-white">
            <h1 class="display-4 fw-bold">مرحبًا بكم في صفحة الهدايا</h1>
            <p class="lead">اختر هديتك المفضلة بكل سهولة واستمتع بالتجربة</p>
            <a href="#gifts" class="btn btn-primary btn-lg mt-4">استعراض الهدايا</a>
        </div>
    </section>
    

    <!-- Gifts Section -->
    <section class="gifts py-5">
        <div
        class="container bg-trasparent my-4 p-3"
        style="position: relative">
        <div
          class="row row-cols-1 row-cols-xs-2 row-cols-sm-2 row-cols-lg-4 g-3"
        >
                @foreach($gifts as $gift)
                   

                <div class="card mx-3 mt-4 position-relative" style="width: 20rem; background-color:#E1D4DF !important ">
                    <img src="{{ asset('dashboard/images/' . $gift->image) }}" class="card-img-top" alt="...">
                    <div class="card-body     position-relative" >
                      <p class="card-text">{{$gift->name_ar}}</p>
                      <div class="text-center my-4 container-btn-select">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#giftModal{{ $gift->id }}"  class="btn btn-select">اختيار الهدية</a>
                      </div>
                    </div>
                  </div>


                   

                    <!-- Modal for Delivery Method -->
                    <div class="modal fade" id="giftModal{{ $gift->id }}" tabindex="-1" aria-labelledby="giftModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="giftModalLabel">اختيار طريقة التوصيل</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form action="{{ url('loyalty/store') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="gift_id" value="{{ $gift->id }}">
                                    <div class="modal-body">
                                        <label for="delivery_method">اختر طريقة التوصيل:</label>
                                        <select name="delivery_method" id="delivery_method" class="form-select">
                                            <option value="shipping">شحن</option>
                                            <option value="pickup">استلام من الفرع</option>
                                        </select>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">تأكيد الاختيار</button>
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
