@extends('layouts.front_layout')



@if (app()->getLocale() == 'en')
    @section('title', $seo?->meta_title_en)

    @section('description', $seo?->meta_description_en)

    @section('canonical', $seo?->canonical_en)
@else
    @section('title', $seo?->meta_title_ar)

    @section('description', $seo?->meta_description_ar)

    @section('canonical', $seo?->canonical_ar)
@endif



@section('css')

    <style>
        body {



            overflow: hidden;

        }



        h1 {

            color: #333;
            /* لون العنوان */

        }



        .card {

            border-radius: 15px;
            /* زوايا دائرية للكارد */

            transition: transform 0.3s, box-shadow 0.3s;
            /* تأثير التحويل عند التمرير */

        }



        .card:hover {

            transform: scale(1.05);
            /* تكبير الكارد عند التمرير */

            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            /* إضافة ظل أكثر عند التمرير */

        }



        .card-title {

            font-size: 1.5rem;
            /* حجم الخط لعنوان الكارد */

        }



        .card-text {

            color: #555;
            /* لون النص */

        }



        #map {

            height: 400px;

            width: 100%;

        }





        .gm-style .gm-style-iw-c {

            max-height: unset !important;

            max-width: unset !important;



            width: 300px !important;

            height: 220px !important;

        }

        .map-image-container img {
            height: 235px !important;
            width: 100%;
        }
    </style>

@endsection



@section('content')



    @php

        $breadcrumb_schema = [
            ['name' => __('lang.Home'), 'url' => url('/')],
            ['name' => __('lang.branches'), 'url' => request()->fullUrl()],
        ];

    @endphp

    @include('components.breadcrumb')

    <div class="m-auto d-flex justify-content-center">



        <div class="container mt-5 mx-2 px-4">

            <h1 class="text-center mb-4 h2"> {{ __('lang.Company_Branches') }}</h1>






            <div id="map"></div>



            <div class="row mt-5 map-image-container">

                <div class="col-lg-3 col-md-4 mb-4">

                    <div class="card shadow-sm ">

                        <div class="card-body">

                            <div class="d-flex align-items-center card-img-wrapper">

                                <img src="{{ asset('web/assets/images/jaddah.jpeg') }}" alt="">


                            </div>

                            <h5 class="card-title mt-2">

                                <a href="https://www.google.com/maps/place/%D8%B4%D8%B1%D9%83%D8%A9+%D8%A7%D9%84%D8%B4%D8%A8%D9%83%D8%A9+%D8%A7%D9%84%D8%AC%D8%AF%D9%8A%D8%AF%D8%A9+%D9%84%D8%AA%D9%82%D8%B3%D9%8A%D8%B7+%D8%A7%D9%84%D8%AC%D9%88%D8%A7%D9%84%D8%A7%D8%AA+%D9%88%D8%A7%D9%84%D8%A7%D9%84%D9%83%D8%AA%D8%B1%D9%88%D9%86%D9%8A%D8%A7%D8%AA+New+Network+for+Mobile+Installment%E2%80%AD/@24.7472604,46.684036,19z/data=!3m1!4b1!4m6!3m5!1s0x3e2efdda300d2377:0x54f2fb0516c469d4!8m2!3d24.7472604!4d46.684036!16s%2Fg%2F11n_zqv4j4?entry=ttu&g_ep=EgoyMDI0MTAyNy4wIKXMDSoASAFQAw%3D%3D"
                                    class="text-primary"> <i class="fas fa-map-marker-alt fa-2x  mr-2"
                                        style="color:#782569"></i></a>
                                فرع الرياض

                            </h5>

                            <p>حي المرسلات -شارع هشام بن عبدالملك</p>

                            <p class="card-text">أوقات الدوام: 12:00 ظهرا - 11:00 مساء</p>

                            <p class="card-text">رقم الهاتف: <a href="tel:+920020696">920020696</a></p>

                        </div>

                    </div>

                </div>

                <div class="col-lg-3 col-md-4 mb-4">

                    <div class="card shadow-sm ">

                        <div class="card-body">

                            <div class="d-flex align-items-center card-img-wrapper">

                                <img src="{{ asset('web/assets/images/jaddah.jpeg') }}" alt="">




                            </div>

                            <h5 class="card-title mt-2 ">
                                <a href="https://share.google/xvng17NoHrSkleB1F" class="text-primary"> <i
                                        class="fas fa-map-marker-alt fa-2x  mr-2" style="color:#782569"></i></a>
                                فرع الرياض
                            </h5>

                            <p> القصر مول -شارع السويدي العام</p>

                            <p class="card-text">أوقات الدوام: 12:00 ظهرا - 11:00 مساء</p>

                            <p class="card-text">رقم الهاتف: <a href="tel:+920020696">920020696</a></p>

                        </div>

                    </div>

                </div>

                <div class="col-lg-3 col-md-4 mb-4">

                    <div class="card shadow-sm">

                        <div class="card-body">

                            <div class="d-flex align-items-center card-img-wrapper">


                                <img src="{{ asset('web/assets/images/jaddah.jpeg') }}" alt="">


                            </div>

                            <h5 class="card-title mt-2 ">

                                <a href="https://maps.app.goo.gl/eX2uiKnvwcjDyoBQ6?g_st=ic" class="text-success"> <i
                                        class="fas fa-map-marker-alt fa-2x  mr-2" style="color:#782569"></i></a>
                                فرع جدة

                            </h5>

                            <p>مجمع الردادي للاتصالات -شارع فلسطين</p>

                            <p class="card-text">أوقات الدوام: 2:00 ظهرا - 11:00 مساء

                            <p class="card-text">رقم الهاتف: <a href="tel:+920020696">920020696</a></p>

                        </div>

                    </div>

                </div>

                <div class="col-lg-3 col-md-4 mb-4">

                    <div class="card shadow-sm ">

                        <div class="card-body">

                            <div class="d-flex align-items-center  card-img-wrapper">

                                <img src="{{ asset('web/assets/images/jaddah.jpeg') }}" alt="">

                            </div>

                            <h5 class="card-title mt-2">
                                <a href="https://www.google.com/maps/place/%D8%B4%D8%B1%D9%83%D8%A9+%D8%A7%D9%84%D8%B4%D8%A8%D9%83%D8%A9+%D8%A7%D9%84%D8%AC%D8%AF%D9%8A%D8%AF%D8%A9+%D9%84%D8%AA%D9%82%D8%B3%D9%8A%D8%B7+%D8%A7%D9%84%D8%AC%D9%88%D8%A7%D9%84%D8%A7%D8%AA%E2%80%AD/@28.434829,36.5689034,15z/data=!4m6!3m5!1s0x15a9b3956f80e52b:0xbf9b583e7de6f934!8m2!3d28.4300739!4d36.5620369!16s%2Fg%2F11k52qzm66?entry=ttu&g_ep=EgoyMDI0MTAyNy4wIKXMDSoASAFQAw%3D%3D"
                                    class="text-danger"> <i class="fas fa-map-marker-alt fa-2x  mr-2"
                                        style="color:#782569"></i></a>

                                فرع تبوك
                            </h5>

                            <p>حي المروج الثاني -طريق الملك فيصل </p>

                            <p class="card-text">أوقات الدوام: 12:00 ظهرا - 10:30 مساء</p>

                            <p class="card-text">رقم الهاتف: <a href="tel:+920020696">920020696</a></p>

                        </div>

                    </div>

                </div>

                <div class="col-lg-3 col-md-4 mb-4 mt-4">

                    <div class="card shadow-sm ">

                        <div class="card-body">

                            <div class="d-flex align-items-center  card-img-wrapper">


                                <img src="{{ asset('web/assets/images/jaddah.jpeg') }}" alt="">



                            </div>

                            <h5 class="card-title ">
                                <a href="https://www.google.com/maps/place/%D8%B4%D8%B1%D9%83%D8%A9+%D8%A7%D9%84%D8%B4%D8%A8%D9%83%D8%A9+%D8%A7%D9%84%D8%AC%D8%AF%D9%8A%D8%AF%D8%A9+%D9%84%D8%AA%D9%82%D8%B3%D9%8A%D8%B7+%D8%A7%D9%84%D8%AC%D9%88%D8%A7%D9%84%D8%A7%D8%AA+%D9%88%D8%A7%D9%84%D8%A7%D9%84%D9%83%D8%AA%D8%B1%D9%88%D9%86%D9%8A%D8%A7%D8%AA+New+Network+for+Mobile+Installment%E2%80%AD/@28.3777852,45.9887857,17z/data=!4m15!1m8!3m7!1s0x3fd7397d04f0b74d:0x19a2097b3b894cd!2z2LTYsdmD2Kkg2KfZhNi02KjZg9ipINin2YTYrNiv2YrYr9ipINmE2KrZgtiz2YrYtyDYp9mE2KzZiNin2YTYp9iqINmI2KfZhNin2YTZg9iq2LHZiNmG2YrYp9iqIE5ldyBOZXR3b3JrIGZvciBNb2JpbGUgSW5zdGFsbG1lbnQ!8m2!3d28.3777411!4d45.9885772!10e5!16s%2Fg%2F11ldvbkn68!3m5!1s0x3fd7397d04f0b74d:0x19a2097b3b894cd!8m2!3d28.3777411!4d45.9885772!16s%2Fg%2F11ldvbkn68?entry=ttu&g_ep=EgoyMDI0MTExOS4yIKXMDSoASAFQAw%3D%3D"
                                    class="text-danger"> <i class="fas fa-map-marker-alt fa-2x  mr-2"
                                        style="color:#782569"></i></a>
                                فرع حفر الباطن

                            </h5>

                            <p>طريق فيصل بن عبدالعزيز، المحمدية </p>

                            <p class="card-text">أوقات الدوام: 4:00 عصرا - 11:00 مساء</p>

                            <p class="card-text">رقم الهاتف: <a href="tel:+920020696">920020696 </a></p>

                        </div>

                    </div>

                </div>

            </div>

        </div>



    </div>

@endsection



@section('js')





    <script>
        // بيانات الفروع مع الإحداثيات

        const branches = [

            {

                name: "المرسلات -الرياض",

                latitude: 24.7472604,

                longitude: 46.684036,

                address: " هشام بن عبدالملك، المرسلات، الرياض 12463"

            },

            {

                name: "القصر مول -الرياض",

                latitude: 24.601296,

                longitude: 46.698257,

                address: " هشام بن عبدالملك، المرسلات، الرياض 12463"

            },

            {

                name: "فرع جدة",

                latitude: 21.5312803,

                longitude: 39.1886001,

                address: "JCMA3282، 3282 شارع فلسطين، 6218، جدة 23331"

            },

            {

                name: "فرع تبوك",

                latitude: 28.434829,

                longitude: 36.5689034,

                address: " مروج الامير، حي المروج الثاني،"

            },

            {

                name: "فرع حفر الباطن",

                latitude: 28.3777411,

                longitude: 45.9885772,

                address: "طريق فيصل بن عبدالعزيز، المحمدية،  "

            }

        ];



        // دالة لتهيئة الخريطة

        function initMap() {

            const map = new google.maps.Map(document.getElementById('map'), {

                zoom: 5, // مستوى التكبير الافتراضي

                center: {
                    lat: 23.8859,
                    lng: 45.0792
                }, // مركز السعودية

                restriction: {

                    latLngBounds: {

                        north: 32.15, // الحد الشمالي

                        south: 16.0, // الحد الجنوبي

                        east: 55.8, // الحد الشرقي

                        west: 34.2 // الحد الغربي

                    },

                    // strictBounds: true // تقييد الخريطة ضمن الحدود المحددة

                }

            });



            // حساب الحدود التي تشمل جميع الفروع

            const bounds = new google.maps.LatLngBounds();



            // إضافة الفروع على الخريطة

            branches.forEach(branch => {

                const marker = new google.maps.Marker({

                    position: {
                        lat: branch.latitude,
                        lng: branch.longitude
                    },

                    map: map,

                    title: branch.name

                });



                const infoWindow = new google.maps.InfoWindow({

                    content: `<p>${branch.name}</p><p>${branch.address}</p>`

                });



                marker.addListener('click', () => {

                    // infoWindow.open(map, marker);

                    const googleMapsUrl =
                        `https://www.google.com/maps?q=${branch.latitude},${branch.longitude}`;

                    window.open(googleMapsUrl, '_blank');

                });



                // إضافة كل فرع إلى الحدود

                bounds.extend(marker.getPosition());

            });



            // ضبط الخريطة لعرض جميع الفروع بشكل كامل

            map.fitBounds(bounds);



            // تأكد من تحديث التكبير بعد إضافة كل الفروع

            google.maps.event.addListenerOnce(map, 'bounds_changed', function() {

                if (map.getZoom() > 10) {

                    map.setZoom(10); // الحد الأقصى للتكبير

                }

            });

        }
    </script>







    <!--<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB4lALgdfRnsitdQfhubPpVejAdFk6uq_4&callback=initMap&v=weekly"
        async defer></script>-->



    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBidp26lsxiul3zZqjcEU1DwgUcc9y03fc&callback=initMap&v=weekly"
        async defer></script>



    <script type="application/ld+json">

    {

      "@context": "https://schema.org/", 

      "@type": "BreadcrumbList", 

      "itemListElement": [{

        "@type": "ListItem", 

        "position": 1, 

        "name": "الرئسية",

        "item": "{{ route('home') }}"  

      },{

        "@type": "ListItem", 

        "position": 2, 

        "name": "فروعنا",

        "item": "{{ request()->fullUrl() }}"  

      }]

    }

    </script>





    <script type="application/ld+json">

{

  "@context": "https://schema.org",

  "@type": "LocalBusiness",

  "name": "شركة الشبكة الجديدة",

  "image": "https://newnetwork.sa/dashboard/images/U6TAbmmdmSlk1681731197.png",

  "@id": "",

  "url": "https://newnetwork.sa/ar",

  "telephone": "920020696",

  "priceRange": "0:20000",

  "address": {

    "@type": "PostalAddress",

    "streetAddress": "شارع السويدي العام",

    "addressLocality": "الرياض",

    "postalCode": "12463",

    "addressCountry": "SA"

  },

  "geo": {

    "@type": "GeoCoordinates",

    "latitude": 24.747469885800232,

    "longitude": 46.68406818650716

  },

  "openingHoursSpecification": [{

    "@type": "OpeningHoursSpecification",

    "dayOfWeek": [

      "Monday",

      "Tuesday",

      "Wednesday",

      "Thursday",

      "Saturday",

      "Sunday"

    ],

    "opens": "10:00",

    "closes": "24:00"

  },{

    "@type": "OpeningHoursSpecification",

    "dayOfWeek": "Friday",

    "opens": "16:00",

    "closes": "24:00"

  }] 

}

</script>









@endsection
