@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.New_post') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('slider.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title_ar">رابط</label>
                            <input type="text" name="url" class="form-control" value="{{ old('url') }}" required>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category">الصنف</label>
                            <select class="form-control" name="category_id" id="category">
                                <option value="">الصفحة الرئسية</option>
                                 @foreach($category as $c)
                                 <option value="{{$c->id}}">{{$c->name_ar}}</option>
                                 @endforeach
                            </select>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
        
                   
                </div>
        
               
        
                <div class="form-group">
                    <label for="image">صورة المقال</label>
                    <input type="file" name="image" class="form-control-file" required>
                    @error('image')
                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>
        
                <button type="submit" class="btn btn-primary ">إنشاء المقال</button>


            </form>
        </div>
    </div>
@endsection
