@extends('layouts.master')

@section('main_title', 'Home Page')
@section('header_title', 'Home')
@section('subheader_title', '#XV2')
@section("cssx")
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endsection
@section('content')


  {{-- <div class="conatiner">
      <form action="{{route('gift.store')}}" method="post">
      @csrf
      <select id="product-select" name="product" class="form-select" style="width: 100%;">
         @foreach($products as $p)
             <option value="{{$p->id}}">{{$p->name_ar}}</option>
         @endforeach
      </select>

     <div class="btn-save">
         <button type="submit">حفظ</button>
     </div>
      </form>
  </div> --}}


    <div class="modal fade" tabindex="-1" id="kt_modal_1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('lang.title_modal') }}</h5>

                    <!--begin::Close-->
                    <div class="btn btn-icon btn-sm btn-active-light-primary ms-2" data-bs-dismiss="modal"
                         aria-label="Close">
                        <span class="svg-icon svg-icon-2x"></span>
                    </div>
                    <!--end::Close-->
                </div>

                <div class="modal-body">
                    <p>{{ __('lang.body_modal') }}</p>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('lang.but_cancel') }}</button>
                    <button class="btn btn-danger" id="save-delete">{{ __('lang.but_save') }}</button>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-5 mb-xl-8">
        <!--begin::Header-->
       
       
        @if(Session::has('success'))
            <div class="alert alert-success" style="margin: 15px">
                {{Session::get('success')}}
            </div>
        @endif
        @if(Session::has('delete'))
            <div class="alert alert-danger" style="margin: 15px">
                {{Session::get('delete')}}
            </div>
        @endif
        @if(Session::has('warning'))
            <div class="alert alert-warning" style="margin: 15px">
                {{Session::get('warning')}}
            </div>
        @endif
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body py-3">
            <!--begin::Table container-->
            <div class="table-responsive" id="table-data">
                <!--begin::Table-->
                @include('dashboard.gift.table-data-client')
            </div>
        </div>
    </div>
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $("#cities").DataTable();
        $(document).on('click', '#status' ,function (e){
            e.preventDefault();
            var id = $(this).data('id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: '{{ route("gift.updateStauts", ":id") }}'.replace(':id', id),
                data: '',
                success: function (response) {
                      

                 
                }
            });
        });

        $(document).on('click', '#delete' ,function (e){
            e.preventDefault();
            var id = $(this).data('id');
            delete_f(id);
        });
        function delete_f(id) {
            $(document).off("click", "#save-delete").on("click", "#save-delete", function (e) {
                e.preventDefault();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'post',
                    url: '{{ url('admin/cities/destroy') }}/' + id,
                    data: '',
                    success: function (response) {
                        Swal.fire({
                            title: '{{ __('lang.Good_job') }}',
                            text: '{{ __('lang.You_clicked_button') }}',
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: '{{ __('lang.Confirm_me') }}',
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                        $('#kt_modal_1').modal('hide');
                        $.ajax({
                            url: "{{ route('cities.index') }}",
                        }).done(function (data) {
                            $("#table-data").html(data);
                            $("#cities").DataTable();
                        });
                    }
                });
            });
        }
    </script>

<script>
    $(document).ready(function() {
        $('#product-select').select2({
            placeholder: 'ابحث عن المنتج...',
            allowClear: true
        });
    });
</script>

@endsection


