@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.edit_post') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('blogAdmin.update', ['id' => $post->id]) }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <input type="hidden" name="post_id" value="{{ $post->id }}">
                        <div class="form-group">
                            <label for="title_ar">عنوان المقال (عربي)</label>
                            <input type="text" name="title_ar" class="form-control" value="{{ $post->title_ar }}"
                                required>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title_en">عنوان المقال (إنجليزي)</label>
                            <input type="text" name="title_en" class="form-control" value="{{ $post->title_en }}"
                                required>
                            @error('title_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="content_ar">محتوى المقال (عربي)</label>
                            <textarea name="content_ar" id="content_ar" class="form-control tinymce" rows="5">{!! $post->content_ar !!}</textarea>
                            @error('content_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="content_en">محتوى المقال (إنجليزي)</label>
                            <textarea name="content_en" id="content_en" class="form-control tinymce" rows="5">{!! $post->content_en !!}</textarea>
                            @error('content_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_title_ar">meta title ar</label>
                            <input type="text" id="meta_title_ar" name="meta_title_ar" class="form-control"
                                value="{{ $post->meta_title_ar }}" required>
                            @error('meta_title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_title_en">meta title en</label>
                            <input type="text" id="meta_title_en" name="meta_title_en" class="form-control"
                                value="{{ $post->meta_title_en }}" required>
                            @error('meta_title_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_desc_ar">meta description ar</label>
                            <textarea name="meta_desc_ar" id="meta_desc_ar" class="form-control " rows="5">{{ $post->meta_desc_ar }}</textarea>
                            @error('meta_desc_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="meta_desc_en">meta description ar</label>
                            <textarea name="meta_desc_en" id="meta_desc_en" class="form-control " rows="5">{{ $post->meta_desc_en }}</textarea>
                            @error('meta_desc_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="slug_ar">slug ar</label>
                            <input type="text" id="slug_ar" name="slug_ar" class="form-control"
                                value="{{ $post->slug_ar }}" required>
                            @error('slug_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="slug_ar">slug en</label>
                            <input type="text" id="slug_en" name="slug_en" class="form-control"
                                value="{{ $post->slug_en }}" required>
                            @error('slug_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="canonical_url_ar">canonical url ar</label>
                            <input type="text" id="canonical_url_ar" name="canonical_url_ar" class="form-control"
                                value="{{ $post->canonical_url_ar }}" required>
                            @error('canonical_url_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="canonical_url_en">canonical url en</label>
                            <input type="text" id="canonical_url_en" name="canonical_url_en" class="form-control"
                                value="{{ $post->canonical_url_en }}" required>
                            @error('canonical_url_en')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>


                <div class="form-group">
                    <label for="image">صورة المقال</label>
                    <input type="file" name="image" class="form-control-file" >
                    <input type="hidden" name="old_image" value="{{ $post->image }}">
                    @error('image')
                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                    @enderror
                </div>

                <div id="questionContainer mt-5 mb-5">
                    @foreach ($fqas as $faq)
                        <div class="question-group" id="questionGroup_{{ $faq->id }}">
                            <label class="form-label" for="question_{{ $faq->id }}">السؤال:</label>
                            <input class="form-control" type="text" id="question_{{ $faq->id }}"
                                name="questions[{{ $faq->id }}][question]" value="{{ $faq->question }}" required>

                            <label class="form-label" for="answer_{{ $faq->id }}">الإجابة:</label>
                            <textarea class="form-control" id="answer_{{ $faq->id }}" name="questions[{{ $faq->id }}][answer]" rows="3" required>{{ $faq->answer }}</textarea>

                            <button type="button" class="btn btn-danger-fqa btn btn-danger"
                                onclick="removeQuestion({{ $faq->id }})">حذف السؤال</button>
                        </div>
                    @endforeach
                </div>
                <button type="button" class="btn btn-secondary mt-5 -mb-5 d-block" style="width: 156px;"
                    onclick="addNewQuestion()">إضافة سؤال جديد</button>





                <button type="submit" class="btn btn-primary mt-5 d-block ">إنشاء المقال</button>


            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdn.tiny.cloud/1/ck45ndr7s2p980n3j5btyvescsat4kmrolihkfnesbozmae6/tinymce/7/tinymce.min.js"
        referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: ".tinymce",
            height: "480",
            menubar: false,
            toolbar: [
                "styleselect fontselect fontsizeselect",
                "undo redo | cut copy paste | bold italic | link image | forecolor backcolor | alignleft aligncenter alignright alignjustify",
                "bullist numlist | outdent indent | blockquote subscript superscript | advlist | autolink | lists charmap | print preview | code | table"
            ],
            plugins: "advlist autolink link image lists charmap print preview code table"
        });
    </script>


    <script>
        let newQuestionCount = 0;

        // Function to add a new question
        function addNewQuestion() {
            newQuestionCount++;
            const questionContainer = document.getElementById('questionContainer');

            const questionGroup = document.createElement('div');
            questionGroup.className = 'question-group shadow-sm form-control';
            questionGroup.id = `newQuestionGroup_${newQuestionCount}`;

            questionGroup.innerHTML = `
            <div class="mb-3">
                <label class="form-label" for="new_question_${newQuestionCount}">السؤال الجديد:</label>
                <textarea  class="form-control" id="new_question_${newQuestionCount}" rows="3" name="new_questions[${newQuestionCount}][question]" placeholder="أدخل السؤال الجديد" required></textarea>
              </di>    
               <div class="mb-3">
                <label  class="form-label"  for="new_answer_${newQuestionCount}">الإجابة الجديدة:</label>
                <textarea  class="form-control" id="new_answer_${newQuestionCount}" name="new_questions[${newQuestionCount}][answer]" rows="3" placeholder="أدخل الإجابة الجديدة" required></textarea>
                </div>
                <button type="button" class="btn btn-danger" onclick="removeNewQuestion(${newQuestionCount})">حذف السؤال الجديد</button>
            `;

            questionContainer.appendChild(questionGroup);
        }

        // Function to remove an existing question visually
        function removeQuestion(id) {
            const questionGroup = document.getElementById(`questionGroup_${id}`);
            questionGroup.remove();
        }

        // Function to remove a newly added question visually
        function removeNewQuestion(id) {
            const questionGroup = document.getElementById(`newQuestionGroup_${id}`);
            questionGroup.remove();
        }
    </script>




@endsection
