@extends('layouts.master')

@section('main_title', 'Home Page')
@section('header_title', 'Home')
@section('subheader_title', '#XV2')

@section('content')


    <div class="card mb-5 mb-xl-8">
        <!--begin::Header-->
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">الطلبات المسبقة</span>
            </h3>

        </div>
        @if (Session::has('success'))
            <div class="alert alert-success" style="margin: 15px">
                {{ Session::get('success') }}
            </div>
        @endif
        @if (Session::has('delete'))
            <div class="alert alert-danger" style="margin: 15px">
                {{ Session::get('delete') }}
            </div>
        @endif
        @if (Session::has('warning'))
            <div class="alert alert-warning" style="margin: 15px">
                {{ Session::get('warning') }}
            </div>
        @endif
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body py-3">
            <!--begin::Table container-->
            <div class="table-responsive" id="table-data">
                <!--begin::Table-->
                @include('dashboard.Preorder.table-data')
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <script>
        $("#cities").DataTable();
        $(document).on('click', '#status', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'post',
                url: '{{ url('admin/cities/Stauts') }}/' + id,
                data: '',
                success: function(response) {
                    $.ajax({
                        url: "{{ route('cities.index') }}"
                    }).done(function(data) {
                        $("#table-data").html(data);
                        $("#cities").DataTable();
                    });
                }
            });
        });

        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            delete_f(id);
        });

        function delete_f(id) {
            $(document).off("click", "#save-delete").on("click", "#save-delete", function(e) {
                e.preventDefault();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'post',
                    url: '{{ url('admin/cities/destroy') }}/' + id,
                    data: '',
                    success: function(response) {
                        Swal.fire({
                            title: '{{ __('lang.Good_job') }}',
                            text: '{{ __('lang.You_clicked_button') }}',
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: '{{ __('lang.Confirm_me') }}',
                            customClass: {
                                confirmButton: "btn btn-primary"
                            }
                        });
                        $('#kt_modal_1').modal('hide');
                        $.ajax({
                            url: "{{ route('cities.index') }}",
                        }).done(function(data) {
                            $("#table-data").html(data);
                            $("#cities").DataTable();
                        });
                    }
                });
            });
        }
    </script>

@endsection
