
@extends('layouts.front_layout')

@section('title',  __('lang.login'))
@section('css')

<style>
      .reset-content {
      background: #fff;
      border-radius: 10px;
      padding: 30px;
      width: 100%;
      max-width: 550px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
      margin: 2rem auto;
    }
    .reset-content .logo img {
      display: block;
      margin: 0 auto 20px;
      width: 80px;
    }
    .reset-content h2 {
      text-align: center;
      color: #333;
      margin-bottom: 20px;
    }
    .reset-content .btn-send {
      background: #7e2a6f;
      color: #fff;
      transition: background-color 0.3s;
    }
    .reset-content .btn-send:hover {
      background: #5146d9;
    }
    .reset-content label {
      font-weight: 500;
      color: #555;
    }
    .reset-content input {
      border: 1px solid #ddd;
      border-radius: 5px;
      padding: 10px;
      font-size: 14px;
      /* height: none; */
      line-height: unset
    }
    .reset-content input:focus {
      border-color: #6c63ff;
      outline: none;
      box-shadow: 0 0 5px rgba(108, 99, 255, 0.5);
    }
    .reset-content .form-footer {
      text-align: center;
      margin-top: 15px;
    }
    .reset-content .form-footer a {
      text-decoration: none;
      color: #6c63ff;
      font-weight: 500;
    }
    .reset-content .form-footer a:hover {
      text-decoration: underline;
    }
  </style>
</style>
 @endsection   

 @section("content")

 

 <section class="reset-content">
    {{-- <div class="logo">
      <img src="{{ Request::root() . '/dashboard/images/' . \App\Models\Settings::where('key_id' , 'logo')->first()->value }}" alt="logo">
    </div> --}}
    <h2>{{ __('lang.reset_password') }}</h2>
    <x-auth-validation-errors class="mb-3" :errors="$errors" />
    <form method="POST" action="{{ route('password.update') }}">
      @csrf
      <input type="hidden" name="token" value="{{ $request->route('token') }}">
      <div class="mb-3">
        <label for="email" class="form-label">{{ __('lang.email') }}</label>
        <input 
          type="email" 
          class="form-control" 
          id="email" 
          name="email" 
          placeholder="Enter your email" 
          value="{{ old('email', $request->email) }}" 
          required>
      </div>
      <div class="mb-3">
        <label for="password" class="form-label">{{ __('lang.new_password') }}</label>
        <input 
          type="password" 
          class="form-control" 
          id="password" 
          name="password" 
          placeholder="Enter your new password" 
          required>
      </div>
      <div class="mb-3">
        <label for="password_confirmation" class="form-label">{{ __('lang.confirm_password') }}</label>
        <input 
          type="password" 
          class="form-control" 
          id="password_confirmation" 
          name="password_confirmation" 
          placeholder="Confirm your password" 
          required>
      </div>
      <button type="submit" class="btn btn-send w-100 py-2">{{ __('lang.reset_password') }}</button>
    </form>
    <!--<div class="form-footer mt-3">-->
    <!--  <a href="{{ route('login') }}">{{ __('lang.back_to_login') }}</a>-->
    <!--</div>-->
  </section>
  

@endsection