<?php

namespace App\Services;

use App\Helper\Messages as HelperMessages;
use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\Http\Resources\ProductResource;
use App\Models\Favorite;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Throwable;

class FavoriteService extends Controller
{

    static function store($data)
    {
        DB::beginTransaction();
        try {
            $fav = Favorite::where('user_id', $data['user_id'])
                ->where('product_id', $data['product_id'])->first();
            if ($fav) {
                return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS', 200);
            }
            Favorite::create($data);
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function destory($id)
    {

        DB::beginTransaction();
        try {
            // Favorite::where('product_id', $id)->where('user_id', Auth::user()->id)->delete();
            Favorite::where('product_id', $id)->where('user_id', 770)->delete();
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'DELETE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function clearUserFavorites()
    {
        DB::beginTransaction();
        try {
            Favorite::where('user_id', auth()->user()->id)->delete();
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'DELETE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function getFavorites()
    {
        DB::beginTransaction();
        try {
            // $data = Favorite::where('user_id', auth()->user()->id)->with('product.user_favorite')->get()->pluck('product');
            $data = Favorite::where('user_id', 770)->with('product')->get()->pluck('product');
            DB::commit();
            return parent::success(ProductResource::collection($data), HelperMessages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
}
