<?php

namespace App\Services;

use App\Helpers\Messages;
use App\Http\Controllers\ControllersService;
use App\Http\Resources\AddressResource;
use App\Models\Address;
use App\Models\City;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Throwable;

class AddressService
{
    static function index()
    {

        try {
            // $addresses = DB::table('addresses')
            //     ->join('cities', 'cities.id', '=', 'addresses.city_id')
            //     ->selectRaw('addresses.* , cities.title_ar as city_en, cities.title_ar as city_ar')
            //     ->get();

            $addresses = Address::with('city')->latest()->get();
            // return $addresses;

            return AddressResource::collection($addresses)
                ->additional(['code' => 200, 'status' => true, 'message' =>  Messages::getMessage('operation accomplished successfully')]);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function store($data)
    {
        DB::beginTransaction();
        try {

            if ($data['is_default'] && $data['is_default'] == "1") {
                $addresses = Address::where(['user_id' => $data['user_id'], 'is_default' => "1"])->get();
                if ($addresses) {
                    foreach ($addresses as $address) {
                        $address->update([
                            'is_default' => "0"
                        ]);
                    }
                }
            }

            Address::create($data);
            DB::commit();
            return ControllersService::generateProcessResponse(true,  'CREATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function show($id)
    {
        try {
            $address = Address::where('id', $id)->first();
            return AddressResource::make($address)
                ->additional(['code' => 200, 'status' => true, 'message' =>  Messages::getMessage('operation accomplished successfully')]);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function update($id, $data)
    {
        DB::beginTransaction();
        try {
            if ($data['is_default'] && $data['is_default'] == "1") {
                $addresses = Address::where(['user_id' => $data['user_id'], 'is_default' => "1"])->get();
                if ($addresses) {
                    foreach ($addresses as $address) {
                        $address->update([
                            'is_default' => "0"
                        ]);
                    }
                }
            }
            Address::find($id)->update($data);
            DB::commit();
            return ControllersService::generateProcessResponse(true,  'UPDATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function destroy($id)
    {
        DB::beginTransaction();
        try {
            Address::find($id)->delete();
            DB::commit();
            return ControllersService::generateProcessResponse(true,  'DELETE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function setDefaultAddress($id)
    {
        DB::beginTransaction();
        try {
            $defaultAddress = Address::where(['is_default' => '1', 'user_id' => auth()->user()->id]);
            if ($defaultAddress) {
                $defaultAddress->update(['is_default' => '0']);
            }
            $newDefaultAddress = Address::where(['id' => $id, 'user_id' => auth()->user()->id])->first();
            if ($newDefaultAddress) {
                $newDefaultAddress->update(['is_default' => '1']);
                DB::commit();
                return ControllersService::generateProcessResponse(true,  'UPDATE_SUCCESS', 200);
            }
            return ControllersService::generateProcessResponse(false,  'NOT_FOUND', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function getCities()
    {

        try {
            $cities = City::latest()->get();

            return AddressResource::collection($cities)
                ->additional(['code' => 200, 'status' => true, 'message' =>  Messages::getMessage('operation accomplished successfully')]);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
}
