<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RedirectIfArabic
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
   
     public function handle(Request $request, Closure $next)
    {
        // اللغات المدعومة
        if (!$request->secure() && app()->environment('production')) {
            return redirect(null,301)->secure($request->getRequestUri());
        }
        
        $supportedLanguages = ['ar', 'en'];
                 
       
        // تحقق من وجود اللغة في الجزء الأول من الرابط
        $segments = $request->segments();
        if (!isset($segments[0]) || !in_array($segments[0], $supportedLanguages)) {
            // الحصول على لغة المتصفح
            $browserLang = substr($request->server('HTTP_ACCEPT_LANGUAGE'), 0, 2);
            $language = in_array($browserLang, $supportedLanguages) ? $browserLang : 'en';
            
             if($browserLang=='en' || $browserLang=='EN' || $browserLang=="En")
            {
                return $next($request);
            }

            // إعادة توجيه الرابط مع إضافة اللغة
            $newUrl = '/' . $language . '/' . implode('/', $segments);
            return redirect($newUrl,301);
        }

        return $next($request);
    }


}
