<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Services\TamamService;

class TamamController extends Controller
{

    public function tamamStart()
    {
        // Step 1: Request Token
        $orderId = 'order_123456';

        // 1. طلب التوكن
        $tamam = new TamamService();
        $tokenResponse = $tamam->requestToken($orderId);
        if (!isset($tokenResponse['response']['client_token'])) {
            return response()->json(['error' => 'فشل في إنشاء Token'], 500);
        }

        $clientToken = $tokenResponse['response']['client_token'];
        $transactionId = $tokenResponse['response']['transaction_id'];

        // 2. بدء الطلب
        $initResponse = $tamam->initiateOrder([
            'app_token' => $clientToken,
            'transaction_id' => $transactionId,
            'redirect_url' => 'https://yourdomain.com/thanks',
            'app_id' => 'MERCHANT-1',

            'customer_name' => 'Ali',
            'customer_address' => 'Riyadh',
            'national_id' => '1234567890',
            'email' => 'ali@example.com',
            'phone' => '966501234567',
            'dob' => '1990-01-01',

            'order_id' => $orderId,
            'reference' => 'ref_001',
            'total_amount' => 2300,
            'items' => [
                [
                    'item_display_name' => 'iPhone 15',
                    'item_desc' => 'iPhone 15 - Blue - 128GB',
                    'sku' => 'IPH15-BLUE',
                    'unit_price' => 2000,
                    'quantity' => 1,
                    'vat_amount' => 300,
                ]
            ]
        ]);

        if (!isset($initResponse['response']['redirection_url'])) {
            return response()->json(['error' => 'فشل في إنشاء الطلب'], 500);
        }

        return redirect($initResponse['response']['redirection_url']);
    }
}
