<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Reviews;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class ReviewController extends Controller
{
    // دالة لفحص إذا النص يحتوي على حروف عربية
    private function isArabic($text)
    {
        return preg_match('/\p{Arabic}/u', $text);
    }

    public function store(Request $request)
    {
        // تحقق من أن المستخدم مسجّل الدخول
        if (!Auth::check()) {
            return response()->json(['error' => 'يجب تسجيل الدخول لإضافة مراجعة'], 401);
        }

        // التحقق من البيانات المُرسلة
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'rating' => 'required|integer|min:1|max:5',
            'note' => 'required|string|max:500',
        ]);

        $text = $request->input('note');
         $apiKey = 'AIzaSyBidp26lsxiul3zZqjcEU1DwgUcc9y03fc';

        // تحديد اللغة الهدف بناءً على هل النص عربي أم لا
        $targetLang = $this->isArabic($text) ? 'en' : 'ar';

        // إرسال طلب الترجمة إلى Google
        $response = Http::asForm()->post('https://translation.googleapis.com/language/translate/v2', [
            'q' => $text,
            'target' => $targetLang,
            'format' => 'text',
            'key' => $apiKey,
        ]);

        if (!$response->successful()) {
            return response()->json(['error' => 'فشل في الترجمة من Google'], 500);
        }

        $responseData = $response->json();
        $translatedText = $responseData['data']['translations'][0]['translatedText'];

        // تعيين النصوص بالعربية والإنجليزية بناءً على اللغة الهدف
        if ($targetLang === 'en') {
            $note_ar = $text;           // النص الأصلي عربي
            $note_en = $translatedText; // الترجمة إنجليزي
        } else {
            $note_en = $text;           // النص الأصلي إنجليزي
            $note_ar = $translatedText; // الترجمة عربي
        }

        // التحقق إذا كانت هناك مراجعة سابقة لهذا المستخدم والمنتج
        $review = Reviews::where('user_id', Auth::id())
            ->where('product_id', $request->product_id)
            ->first();

        if ($review) {
            // تحديث المراجعة
            $review->update([
                'rate' => $request->rating,
                'note' => $note_ar,
                'note_en' => $note_en,
            ]);
        } else {
            // إنشاء مراجعة جديدة
            Reviews::create([
                'user_id' => Auth::id(),
                'product_id' => $request->product_id,
                'rate' => $request->rating,
                'note' => $note_ar,
                'note_en' => $note_en,
            ]);
        }

        return response()->json(['message' => 'تم حفظ التقييم بنجاح']);
    }
}
