<?php

namespace App\Http\Controllers\Tabby;

use App\Models\Order;
use App\Models\Register_transaction;
use App\Models\User;
use App\Services\TabbyService;
// use App\Services\TabbyService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Mail\OrderMail;
use App\Models\Carts;
use App\Models\Colors;
use App\Models\OrderItem;
use App\Models\Products;
use App\Models\Settings;
use App\Repositories\Cart\CartRepository;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class TabbyController extends Controller

{
    public $base_url = "https://api.tabby.ai/api/v2/";
    public $pk_test = "pk_test_31f72d93-d792-4e0d-8147-209ad96a4d73";
    public $sk_test = "sk_test_27f29ac3-51ab-4b80-97d0-8e578cfa00f2";
    //

    public function get_redirect_link(Request $request, $id_order)
    {
        if (! $request->hasValidSignature()) {
            return abort(401);
        }
        if ($id_order < 0) {
            toastr()->warning('اقل قيمة للدفع هي 100');
            return back();
        }
        $order = Order::findorfail($id_order);
        // $price = $order->total;

        // $price = round($price, 2);



        // $tabby = new TabbyService();
        $order_data = $this->prepare_data($order);




        $payment = $this->createSession($order_data);

        if ($payment?->status == 'rejected') {
            $meg_error = $payment?->configuration?->products?->installments?->rejection_reason;
            $message = $meg_error;
            if ($meg_error == "not_available")
                $message = "Sorry, Tabby is unable to approve this purchase. Please use an alternative payment method for your order.";
            elseif ($meg_error == "order_amount_too_high")
                $message = "This purchase is above your current spending limit with Tabby, try a smaller cart or use another payment method";
            elseif ($meg_error == "order_amount_too_low")
                $message = "The purchase amount is below the minimum amount required to use Tabby, try adding more items or use another payment method";


            toastr()->warning($message);
            return back();
        }

        $transaction_id = $payment->id;
        
        // dd($transaction_id);

        $register_transaction = Register_transaction::create([
            "uuid" => $payment->payment->id,
            "order_id" => $id_order
        ]);

        $id = $payment->id;
        if ($register_transaction) {
            $order->register_transaction_id = $transaction_id;
            $order->save();
            $redirect_url = $payment->configuration->available_products->installments[0]->web_url;

            return redirect($redirect_url);
        } else {
            abort("404");
        }
    }

    public function createSession($data)
    {
        $body = $this->getConfig($data);

        // return $body;

        $http = Http::withToken($this->sk_test)->baseUrl($this->base_url);

        $response = $http->post('checkout', $body);

        return $response->object();
    }

    public function getSession($payment_id)
    {
        $http = Http::withToken($this->sk_test)->baseUrl($this->base_url);

        $url = 'checkout/' . $payment_id;

        $response = $http->get($url);

        return $response->object();
    }

    public function getConfig($data)
    {

        // dd($data['loyalty_level']);
        $body = [];

        $body = [
            "payment" => [
                "amount" => $data['amount'],
                "currency" => $data['currency'],
                "description" =>  $data['description'],
                "buyer" => [
                    "phone" => $data['buyer_phone'],
                    "email" => $data['buyer_email'],
                    "name" => $data['full_name']
                ],
                "shipping_address" => [
                    "city" => $data['city'],
                    "address" =>  $data['address'],
                    "zip" => $data['zip'],
                ],
                "order" => [
                    "tax_amount" => "0.00",
                    "shipping_amount" => "0.00",
                    "discount_amount" => "0.00",
                    "updated_at" => now(),
                    "reference_id" => (string) $data['order_id'],
                    "items" =>
                    $data['items'],
                ],
                "buyer_history" => [
                    "registered_since" => $data['registered_since'],
                    "loyalty_level" => $data['loyalty_level'],
                ],
                "order_history" =>
                $data['order_history']

            ],
            "lang" => app()->getLocale(),
            "merchant_code" => "NewNtwrk",
            "merchant_urls" => [
                "success" => $data['success-url'],
                "cancel" => $data['cancel-url'],
                "failure" => $data['failure-url'],
            ]
        ];

        return $body;
    }

    public function capturePayment($id, $total, $order_id)
    {
        $url = "https://api.tabby.ai/api/v2/payments/{$id}/captures";

        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->sk_test, // استبدل بمفتاحك السري
            'Content-Type' => 'application/json',
        ])->post($url, [
            'amount' => $total,
        ]);

        // طباعة الاستجابة
        $data = $response->json();
        if (!empty($data['captures'])) {
            $register_transaction = Register_transaction::where("order_id", "=", $order_id)->first();
            if ($register_transaction->status != "withdraw") {

                $register_transaction->status = "withdraw";
                $register_transaction->save();
                $user = Auth::user();
                $total_quantity = Carts::with('product')->whereHas('product', function ($query) {
                    $query->where('status', 1);
                })->where('user_id', Auth::user()->id)->sum('quantity');
                $total_weight = Carts::with('product')->whereHas('product', function ($query) {
                    $query->where('status', 1);
                })->where('user_id', Auth::user()->id)->get()->sum(function ($cart) {
                    return $cart->product->weight;
                });
                $location = Settings::where('key_id', 'location_ar')->first()->value;
                $phone = Settings::where('key_id', 'phone')->first()->value;
                $order = Order::findorfail($order_id);
                $order->payment_status = "paid";
                $order->status = "complete";
                $order->save();
                // $order->payment_status = 'paid';
                $OrderItem = OrderItem::whereHas('order', function ($q) use ($order) {
                    $q->where('order_id', $order->id);
                })->get();
                foreach ($OrderItem as $items) {
                    $product_s = Products::with('colors')->find($items->product_id);
                    $product_s->update([
                        'quantity' => $product_s->quantity - $items->quantity,
                    ]);
                    $colors = Colors::where('product_id', $items->product_id)->where('color', $items->options)->first();
                    //                return $colors;
                    $colors->update([
                        'quantity' => $colors->quantity - $items->quantity,
                    ]);
                }
                $cart = new CartRepository();
                $cart->empty();
                Mail::to(Auth::user()->email)->send(new OrderMail($order));
                return true;


                // return $data;
            }
        } else {
            $order = Order::findorfail($order_id);
            $order->payment_status = "pending";
            $order->status = "new";
            $order->save();
            return false;
        }
    }



    public function processing_payment(Request $request, $order_id)
    {

        // return $request->payment_id;
        $order = Order::findorfail($order_id);
        $total = $order->total;
        if ($request->payment_id) {
            $is_correct = $this->capturePayment($request->payment_id, $total, $order->id);
            if ($is_correct) {
                toastr()->success(__('lang.order_done'));
                return redirect()->route('account.index');
            } else {
                toastr()->warning('جاري معالجة الطلب');
                return redirect()->route('home');
            }
        } else {
            toastr()->warning('فشلت عملية الدفع');
            return redirect()->route('home');
        }
    }

    public function prepare_data($order)
    {

        $order_items = $order->order_item;
        $user = Auth::user();
        $ta_items = [];
        $itemx = [];
        foreach ($order_items as $item) {
            $itemx['title'] = $item->product_name;
            $itemx['unit_price'] = $item->price;
            $itemx['quantity'] = $item->quantity;
            $itemx['category'] = "Electronics";
            array_push($ta_items, $itemx);
        }

        $order_history = Order::with(['order_item', 'user', 'addresses']) // تحميل العلاقة مسبقًا
            ->where("user_id", $user->id)
            ->where("id", "!=", $order->id)
            ->where("payment_status", "paid")
            ->get();

        $old_oreder = [];

        foreach ($order_history as $item) {
            $itemx = [];
            $itemx['purchased_at'] = $item->created_at;
            $itemx['amount'] = $item->total;
            $itemx['status'] = $order->status;
            $itemx['buyer'] = ["name" => $item->user->user_name, "email" => $item->user->email, "phone" => $item->user->phone];
            $itemx['shipping_address'] = ["city" => $item->addresses->cities->name_ar, "address" => $item->addresses->street . ' ' . $item->addresses->district, "zip" => $item->addresses->zip];

            // dd($item);

            $itemx['items'] = $item->order_item
                ? $item->order_item->map(function ($orderItem) {
                    return [
                        'title' => $orderItem->product_name,
                        'unit_price' => $orderItem->price,
                        'quantity' => $orderItem->quantity,

                    ];
                })
                : [];

            $old_oreder[] = $itemx;
        }
        // dd($old_oreder);
        $success_url = URL::signedRoute("tabby_processing_payment", $order->id);
        $failure_url = URL::signedRoute('tabby_failure_payment', $order->id);
        $cancel_url = URL::signedRoute('tabby_cancel_payment', $order->id);


        // $customer = new User();
        $order_data = [
            'amount' => $order->total,
            'currency' => 'SAR',
            'description' => '',
            'full_name' => $user->user_name,
            'buyer_phone' => $user->phone,
            'buyer_email' => $user->email,
            'address' => $order->addresses->street . ' ' . $order->addresses->district,
            'city' => $order->addresses->cities->name_ar,
            'zip' => '',
            'order_id' => $order->id,
            'registered_since' => $user->created_at,
            // 'loyalty_level' => 0,

            'success-url' =>  $success_url,
            'cancel-url' => $cancel_url,
            'failure-url' => $failure_url,
            'items' => $ta_items,
            'loyalty_level' => Order::where("user_id", $user->id)->where("payment_status", "paid")->count(),
            "order_history" => $old_oreder,
        ];
        return $order_data;
    }
    public function failure_payment($id)
    {

        toastr()->warning('فشلت عملية الدفع ');
        $order = Order::find($id);
        if ($order) {
            $order->payment_status = "failed";
            $order->status = "unknown";
            $order->save();
            return redirect()->route("home");
        } else {

            return redirect()->route("home");
        }
    }
    public function cancel_payment($id)
    {
        toastr()->warning(' لقد ألغيت الدفعة. فضلاً حاول مجددًا أو اختر طريقة دفع أخرى');
        $order = Order::find($id);
        if ($order) {
            $order->payment_status = "failed";
            $order->status = "canceled";

            $order->save();
            return redirect()->route("home");
        } else {

            return redirect()->route("home");
        }
    }
    public function register_webhook()
    {
        // dd(route('tabby.receive_events'));
        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . $this->sk_test,
            'X-Merchant-Code' => "NewNtwrk",
            'Content-Type' => 'application/json',
        ])->post('https://api.tabby.ai/api/v1/webhooks', [
            'url' => route('tabby.receive_events'), // أو أي رابط عندك يستقبل الطلبات
            'is_test' => true, // غيّرها لـ false في بيئة الإنتاج
            'header' => [
                'title' => 'X-Tabby-Signature',
                'value' => 'secure-newnetwork-123456',
            ]
        ]);

        // التحقق من نجاح الطلب
        if ($response->successful()) {
            // dd($response);
            return response()->json(['message' => 'تم تسجيل الـ Webhook بنجاح']);
        } else {
            return response()->json([
                'message' => 'فشل التسجيل',
                'error' => $response->body()
            ], $response->status());
        }
    }
    public function receive_events(Request $request)
    {
        Log::info($request);
        $data = $request->all();

        // الحصول على رقم الطلب من Webhook
        $referenceId = $data['order']['reference_id'] ?? null;
        $status = $data['status'] ?? null;
        
        Log::info('Reference ID received', ['reference_id' => $referenceId,'status'=>$status]);


        if (!$referenceId || !$status) {
            return response()->json(['error' => 'Missing data'], 400);
        }

        // البحث عن الطلب وتحديث حالته
        $order = Order::find($referenceId);

        if ($order) {
            switch ($status) {
                case 'authorized':

                    $register_transaction = Register_transaction::where("order_id", $referenceId)->first();
                    $result = $this->capturePayment($register_transaction->uuid, $data['amount'], $order->id);
                     Log::info('register_transaction ', ['register_transaction' => $register_transaction->uuid,'ammount'=>$data['amount'],'order_idd'=>$order->id]);
                    if ($result) {
                        return response()->json(['message' => 'Order updated successfully'], 200);
                    } else {
                        Log::info("can't caputre tabby payment");
                    }

                    break;

                case 'Capture':
                case 'capture':
                    $order->payment_status = "paid";
                    $order->status = "complete";
                    $order->save();
                    break;

                case 'closed':
                case 'Closed':
                case 'close':
                case 'closed':
                    $order->payment_status = "paid";
                    $order->status = "complete";
                    $order->save();
                    return response()->json(['message' => 'Order updated successfully'], 200);
                    break;


                case 'rejected':
                case 'reject':
                    // الحالة "rejected"	
                    $order->payment_status = "failed";
                    $order->status = "unknown";
                    $order->save();
                    return response()->json(['message' => 'Order updated successfully'], 200);
                    break;

                case 'expired':
                case 'expire':
                    // الحالة "expired"، تحقق من is_expired
                    $order->payment_status = "failed";
                    $order->status = "unknown";

                    $order->save();
                    return response()->json(['message' => 'Order updated successfully'], 200);
                    break;

                case 'Refund':
                case 'refund':
                    // تحقق من refunds array
                    $order->payment_status = "Refund";
                    $order->status = "refunded";
                    $order->save();
                    return response()->json(['message' => 'Order updated successfully'], 200);
                    break;

                case 'Update':
                    // تحديث رقم الطلب reference_id
                    break;
            }
        }
    }
}
