<?php

namespace App\Http\Controllers\API\V1;

use App\Helper\Messages;
use App\Http\Controllers\Controller;
use App\Http\Requests\FavoriteRequest;
use App\Models\Favorite;
use App\Services\FavoriteService;
use Illuminate\Http\Request;

class FavoritesController extends Controller
{
    // public function store(FavoriteRequest $favoriteRequest)
    // {
    //     return FavoriteService::store($favoriteRequest->favData());
    // }


    public function store(Request $request)
    {
        // return FavoriteService::store($request->all());
        $fav = Favorite::where('user_id', $request['user_id'])
            ->where('product_id', $request['product_id'])->first();
        if ($fav) {
            return parent::success($fav, Messages::getMessage('operation accomplished successfully'));
        } else {
            if (Favorite::create($request->all()))
                return parent::success($fav, Messages::getMessage('operation accomplished successfully'));
            else
                return parent::error(Messages::getMessage('operation accomplished successfully'), $request->all);
        }
    }
    public function destroy($id)
    {
        return FavoriteService::destory($id);
    }

    public function clearUserFavorites()
    {
        return FavoriteService::clearUserFavorites();
    }

    // getFavorites
    public function index()
    {
        return FavoriteService::getFavorites();
    }
}
