<?php

namespace App\Http\Controllers\API\V1;

use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryCollection;
use App\Http\Resources\CategoryResource;
use App\Models\Category;
use App\Models\Categories;
use Illuminate\Http\Request;
use App\Models\Products;
// use App\Helper\Messages;

class CategoriesController extends Controller
{

    public function __invoke(Request $request)
    {
        $categories = Category::when($request->parent_id, function($q) use ($request) {
            $q->where('parent_id', $request->parent_id);
        })->when($request->name, function($q) use ($request) {
            $q->where('title_ar', 'like', '%' . $request->name . '%')
            ->orWhere('title_en' , 'like' , '%'. $request->name . '%');
        })->where('parent_id' , null)->get();

        return CategoryResource::collection($categories)
        ->additional(['code' => 200 , 'status' => true ,'message' =>  Messages::getMessage('operation accomplished successfully')]);
    }
    
    public function index()
    {
        $categories = Categories::where('status', 1)->where('parent_id', null)->get();
        // return parent::success($categories, Messages::getMessage('operation accomplished successfully'));
        return parent::success($categories,  'successfully');
    }
    
    public function product_category($id)
    {
        
        
         $category = Categories::with('children')->find($id);
         

        // الخطوة 2: استخراج كل التصنيفات التابعة له
        $categoryIds = $this->getAllCategoryIds($category);
        
        

        // الخطوة 3: جلب المنتجات المرتبطة بأي من هذه التصنيفات
        $products_s = Products::with(['favorite', 'colors'])
            ->where('status', 1)
            ->whereHas('categories', function ($query) use ($categoryIds) {
                $query->whereIn('id', $categoryIds);
            })
            ->orderBy('order_sort', 'asc')
            ->orderBy('price', 'desc')
            ->whereNull("parent_product_id")
            ->get();
        // echo $products_s->toSql();
        


        // $cat = Categories::get();
        $cat = Categories::where('parent_id', $id)->get();
        $cat_seo = Categories::find($id);

        $min = Products::first();
        $max = Products::orderBy('id', 'desc')->first();
        if ($min || $max) {
            $single_product = Products::where('id', rand($min->id, $max->id))->first();
        } else {
            $single_product = Products::first();
        }
        
        return parent::success($products_s,  'successfully');
        
        
    }
     function getAllCategoryIds($category)
    {
        $ids = collect([$category->id]);

        foreach ($category->children as $child) {
            $ids = $ids->merge($this->getAllCategoryIds($child));
        }

        return $ids;
    }
    
    
}
