<?php

namespace App\Console\Commands;

use App\Mail\AbandonedCartReminder;
use App\Models\Carts;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class SendAbandonedCartEmails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:abandoned-cart-emails';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // تحديد السلة المهجورة (من اليوم السابق) حيث لم يتم إتمام الشراء
        $yesterday = now()->subDay()->toDateString();

        $carts = Carts::whereDate('updated_at', $yesterday)
            ->orWhereDate("created_at", $yesterday)
            ->with(['user', 'product'])
            ->get();

        // Log for debugging
        Log::info('Abandoned cart job running...');
        Log::info('Found carts: ' . $carts->count());
        Log::info($yesterday);

        // Group carts by user
        $cartsGroupedByUser = $carts->groupBy('user_id');

        foreach ($cartsGroupedByUser as $userId => $userCarts) {
            $user = $userCarts->first()->user;
            $products = $userCarts->pluck('product');

            Log::info("Sending abandoned cart email to: " . $user->email);
            Log::info("User: " . $user->toJson());
            Log::info("Products: " . $products->toJson());

            // Send one email with all products in the cart
             if($user->email !=null)
            Mail::to($user->email)->send(new AbandonedCartReminder($user, $products));
        }
    }
}
