<?php

namespace App\Services;

use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\Http\Resources\CartResource;
use App\Models\Cart;
use App\Models\CartItem;
use Illuminate\Support\Facades\DB;
use Throwable;

class CartService extends Controller
{
    static function index()
    {
        try {
            $cart = Cart::where('user_id', auth('sanctum')->user()->id)->with('cartItems.product', 'cartItems.variant')
                ->first();
            return parent::success(CartResource::make($cart), Messages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function store($data)
    {
        DB::beginTransaction();
        try {
            $cartId = Cart::updateOrCreate(['device_token' => $data['device_token']], [
                'user_id' => $data['user_id'],
                'copoun_id' => $data['copoun_id'],
            ])->id;

            CartItem::create([
                'cart_id' => $cartId,
                'product_id' => $data['product_id'],
                'variant_id' => $data['variant_id'],
                'quantity' => $data['quantity'],
            ]);

            DB::commit();
            return ControllersService::generateProcessResponse(true,  'CREATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }


    static function update($id, $data)
    {
        DB::beginTransaction();
        try {
            $cart = Cart::find($id);
            if ($cart->user_id == auth('sanctum')->id()) {
                foreach ($data['items'] as $item) {
                    CartItem::find($item['id'])->update([
                        'quantity' => $item['quantity']
                    ]);
                }
            }
            DB::commit();
            return ControllersService::generateProcessResponse(true,  'UPDATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function destroy($id)
    {
        DB::beginTransaction();
        try {
            CartItem::find($id)->delete();
            DB::commit();
            return ControllersService::generateProcessResponse(true,  'DELETE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
}
